/* mã nguồn mở được góp nhặt từ nhiều nơi */

(function() {
    var lastTime = 0;
    var vendors = ['webkit', 'moz'];
    for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
        window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
        window.cancelAnimationFrame =
          window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
    }

    if (!window.requestAnimationFrame)
        window.requestAnimationFrame = function(callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
            var id = window.setTimeout(function() { callback(currTime + timeToCall); },
              timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };

    if (!window.cancelAnimationFrame)
        window.cancelAnimationFrame = function(id) {
            clearTimeout(id);
        };
}());

function querystring(formname)
{
	if(formname == 'none') return '';
    var form = document.forms[formname];
	var str = '';

    function getval(name, value)
	{
		str += (str.length > 0 ? "&" : "") + name + "=" + encodeURIComponent(value);
    }
	
	var a = form.elements;
    for (var i = 0; i < a.length; i++)
	{
        var element = a[i];
        var type = element.type.toUpperCase();
        var name = element.name;
        if (name)
		{
            if(	type == "TEXT" ||
				type == "TEXTAREA" ||
				type == "PASSWORD" ||
				type == "BUTTON" ||
				type == "RESET" ||
				type == "SUBMIT" ||
				type == "FILE" ||
				type == "IMAGE" ||
				type == "HIDDEN")
			{
                getval(name, element.value);
			}
            else if(type == "CHECKBOX" && element.checked)
			{
                getval(name, element.value ? element.value : "On");
			}
            else if(type == "RADIO" && element.checked)
			{
                getval(name, element.value);
			}
            else if(type.indexOf("SELECT") != -1)
			{
                for (var j = 0; j < element.options.length; j++)
				{
                    var option = element.options[j];
                    if(option.selected) getval(name, option.value ? option.value : option.text);
                }
			}
        }
    }
    return str;
}
function getWindowDims()
{
    var doc = document, w = window;
    var docEl = (doc.compatMode && doc.compatMode === 'CSS1Compat')? doc.documentElement: doc.body;
    var width = docEl.clientWidth;
    var height = docEl.clientHeight;
    if (w.innerWidth && width > w.innerWidth)
	{
        width = w.innerWidth;
        height = w.innerHeight;
    }
    return {width: width, height: height};
}
function isElementOutViewport (el) {
    var rect = el.getBoundingClientRect();
    return rect.bottom < 0 || rect.right < 0 || rect.left > window.innerWidth || rect.top > window.innerHeight;
}
function isElementInViewport (el) {
    var rect = el.getBoundingClientRect();
    return (
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&     
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)
    );
}
function base64ToBuffer(base64)
{
    var binary = window.atob(base64);
    var buffer = new ArrayBuffer(binary.length);
    var bytes = new Uint8Array(buffer);
    for (var i = 0; i < buffer.byteLength; i++) {
        bytes[i] = binary.charCodeAt(i) & 0xFF;
    }
    return buffer;
}